/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.animal;

import com.lothrazar.cyclic.api.IEntityInteractable;
import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.util.ChatUtil;
import com.lothrazar.cyclic.util.ParticleUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ItemHorseEnder
extends ItemBaseCyclic
implements IEntityInteractable {
    public static final String NBT_KEYACTIVE = "cyclic_carrot_ender";

    public ItemHorseEnder(Item.Properties prop) {
        super(prop);
    }

    public static void onSuccess(LivingEntity liv) {
        SoundUtil.playSound((Entity)liv, SoundEvents.f_11911_);
        ParticleUtil.spawnParticle(liv.f_19853_, (ParticleOptions)ParticleTypes.f_123797_, liv.m_142538_(), 3);
        ItemHorseEnder.increment(liv, -1);
    }

    private static void increment(LivingEntity ahorse, int val) {
        int old = ahorse.getPersistentData().m_128451_(NBT_KEYACTIVE);
        ahorse.getPersistentData().m_128405_(NBT_KEYACTIVE, old + val);
    }

    @Override
    public void interactWith(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().m_41720_() == this && event.getTarget() instanceof AbstractHorse && !event.getPlayer().m_36335_().m_41519_((Item)this)) {
            AbstractHorse ahorse = (AbstractHorse)event.getTarget();
            if (event.getTarget() instanceof AbstractChestedHorse && ahorse.m_30614_()) {
                AbstractChestedHorse ss = (AbstractChestedHorse)event.getTarget();
                ss.m_30504_(true);
            }
            ItemHorseEnder.increment((LivingEntity)ahorse, 1);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.getPlayer().m_36335_().m_41524_((Item)this, 1);
            event.getItemStack().m_41774_(1);
            int current = ahorse.getPersistentData().m_128451_(NBT_KEYACTIVE);
            ChatUtil.addChatMessage(event.getPlayer(), ChatUtil.lang("item.cyclic.carrot_ender.count") + current);
        }
    }
}

